<?php
// Kurulum kontrolü
if (!file_exists('includes/config.php')) {
    header('Location: setup.php');
    exit;
}

require_once 'includes/config.php';

// Kategori slug'ını al
$slug = $_GET['slug'] ?? '';

if (empty($slug)) {
    header('Location: index.php');
    exit;
}

// Kategori bilgisini çek
$stmt = $pdo->prepare("SELECT * FROM categories WHERE slug = ? AND is_active = 1");
$stmt->execute([$slug]);
$category = $stmt->fetch();

if (!$category) {
    header('Location: index.php');
    exit;
}

// Alt kategorileri çek (varsa)
$stmt = $pdo->prepare("SELECT * FROM subcategories WHERE category_id = ? ORDER BY display_order ASC");
$stmt->execute([$category['id']]);
$subcategories = $stmt->fetchAll();

// Ürünleri çek
if (!empty($subcategories)) {
    // Alt kategorili ürünler
    $products_by_subcat = [];
    foreach ($subcategories as $subcat) {
        $stmt = $pdo->prepare("
            SELECT p.* FROM products p
            JOIN product_subcategories ps ON p.id = ps.product_id
            WHERE ps.subcategory_id = ? AND p.is_active = 1
            ORDER BY p.display_order ASC, p.name ASC
        ");
        $stmt->execute([$subcat['id']]);
        $products_by_subcat[$subcat['id']] = $stmt->fetchAll();
    }
} else {
    // Normal ürünler
    $stmt = $pdo->prepare("
        SELECT * FROM products 
        WHERE category_id = ? AND is_active = 1 
        ORDER BY display_order ASC, name ASC
    ");
    $stmt->execute([$category['id']]);
    $products = $stmt->fetchAll();
}

// Tüm kategorileri çek (alt menü için)
$all_categories = $pdo->query("SELECT * FROM categories WHERE is_active = 1 ORDER BY display_order ASC")->fetchAll();

// Ayarlar
$phone = getSetting('phone', '05078531610');
$maps_url = getSetting('maps_url', 'https://maps.app.goo.gl/XbFYeuwkYQBQJwxu7');
$currency = getSetting('currency', '₺');

function getSetting($key, $default = '') {
    global $pdo;
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->execute([$key]);
    $result = $stmt->fetchColumn();
    return $result !== false ? $result : $default;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo htmlspecialchars($category['name']); ?> - QR Menü</title>
  <meta name="theme-color" content="#8b5e3c">
  <script src="https://cdn.tailwindcss.com"></script>
  <style>
    @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
    body { font-family: 'Poppins', sans-serif; }
    html { scroll-behavior: smooth; }
    
    .menu-item {
      transition: all 0.2s ease;
    }
    .menu-item:hover {
      background: linear-gradient(to right, #fef3c7, #fed7aa);
      transform: translateX(4px);
    }
  </style>
</head>
<body class="bg-gradient-to-br from-amber-50 via-white to-orange-50">
  <!-- Üst Menü -->
  <header class="bg-white/95 backdrop-blur-md shadow-lg sticky top-0 z-50 border-b-2 border-amber-100">
    <div class="flex items-center justify-between px-4 py-4 max-w-6xl mx-auto">
      <a href="index.php" class="flex items-center gap-2 group">
        <svg class="w-6 h-6 text-amber-600 group-hover:-translate-x-1 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
        </svg>
        <img src="logo.png" alt="Logo" class="h-12 w-auto max-w-[150px]">
      </a>
      <div class="flex items-center gap-2">
        <a href="<?php echo htmlspecialchars($maps_url); ?>" target="_blank" 
           class="p-2.5 bg-blue-500 text-white rounded-full hover:bg-blue-600 transition-all hover:scale-110 shadow-lg">
          <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 16" class="w-5 h-5">
            <path d="M8 0a5.53 5.53 0 0 0-5.5 5.5c0 3.038 5.5 10.5 5.5 10.5s5.5-7.462 5.5-10.5A5.53 5.53 0 0 0 8 0zm0 8a2.5 2.5 0 1 1 0-5 2.5 2.5 0 0 1 0 5z"/>
          </svg>
        </a>
        <a href="tel:<?php echo htmlspecialchars($phone); ?>" 
           class="p-2.5 bg-green-500 text-white rounded-full hover:bg-green-600 transition-all hover:scale-110 shadow-lg">
          <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 16 16" class="w-5 h-5">
            <path d="M3.654 1.328a.678.678 0 0 1 .717-.164l2.453.978c.265.105.433.37.433.652v2.01c0 .276-.12.54-.328.71l-1.015.814a11.72 11.72 0 0 0 4.516 4.516l.814-1.015a.734.734 0 0 1 .71-.328h2.01c.282 0 .547.168.652.433l.978 2.453a.678.678 0 0 1-.164.717l-2.017 2.017c-.22.22-.53.304-.829.217a15.573 15.573 0 0 1-8.91-8.91.678.678 0 0 1 .217-.829l2.017-2.017z"/>
          </svg>
        </a>
      </div>
    </div>
  </header>

  <!-- Hero Image -->
  <?php if ($category['image'] && file_exists($category['image'])): ?>
    <div class="relative h-64 overflow-hidden">
      <img src="<?php echo htmlspecialchars($category['image']); ?>" 
           alt="<?php echo htmlspecialchars($category['name']); ?>" 
           class="w-full h-full object-cover">
      <div class="absolute inset-0 bg-gradient-to-t from-black/70 via-black/30 to-transparent"></div>
      <div class="absolute bottom-0 left-0 right-0 p-6 text-white">
        <div class="max-w-6xl mx-auto">
          <h1 class="text-4xl md:text-5xl font-bold mb-2"><?php echo htmlspecialchars($category['name']); ?></h1>
          <p class="text-amber-200 flex items-center gap-2">
            <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
              <path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z"/>
              <path fill-rule="evenodd" d="M4 5a2 2 0 012-2 3 3 0 003 3h2a3 3 0 003-3 2 2 0 012 2v11a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm3 4a1 1 0 000 2h.01a1 1 0 100-2H7zm3 0a1 1 0 000 2h3a1 1 0 100-2h-3zm-3 4a1 1 0 100 2h.01a1 1 0 100-2H7zm3 0a1 1 0 100 2h3a1 1 0 100-2h-3z" clip-rule="evenodd"/>
            </svg>
            Menüyü keşfedin
          </p>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <!-- Menü İçeriği -->
  <div class="max-w-4xl mx-auto px-4 py-8 pb-32">
    <div class="bg-white/80 backdrop-blur-sm rounded-3xl shadow-2xl overflow-hidden border-2 border-amber-100">
      <div class="p-6 md:p-8">
        
        <?php if (!empty($subcategories)): ?>
          <!-- Alt kategorili gösterim -->
          <?php foreach ($subcategories as $subcat): ?>
            <?php if (!empty($products_by_subcat[$subcat['id']])): ?>
              <div class="mb-10">
                <div class="flex items-center gap-3 mb-6 pb-3 border-b-2 border-amber-200">
                  <div class="w-1 h-8 bg-gradient-to-b from-amber-500 to-orange-500 rounded-full"></div>
                  <h2 class="text-2xl font-bold text-amber-800">
                    <?php echo htmlspecialchars($subcat['name']); ?>
                  </h2>
                </div>
                
                <div class="space-y-2">
                  <?php foreach ($products_by_subcat[$subcat['id']] as $product): ?>
                    <div class="menu-item flex items-start justify-between p-4 rounded-xl border border-amber-100">
                      <div class="flex-1">
                        <h3 class="text-lg font-semibold text-gray-800 mb-1">
                          <?php echo htmlspecialchars($product['name']); ?>
                        </h3>
                        <?php if ($product['description']): ?>
                          <p class="text-sm text-gray-600 leading-relaxed">
                            <?php echo htmlspecialchars($product['description']); ?>
                          </p>
                        <?php endif; ?>
                      </div>
                      <?php if ($product['price'] > 0): ?>
                        <div class="ml-4 flex-shrink-0">
                          <span class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-amber-500 to-orange-500 text-white font-bold rounded-full text-lg shadow-lg">
                            <?php echo number_format($product['price'], 0, ',', '.') . $currency; ?>
                          </span>
                        </div>
                      <?php endif; ?>
                    </div>
                  <?php endforeach; ?>
                </div>
              </div>
            <?php endif; ?>
          <?php endforeach; ?>
        <?php else: ?>
          <!-- Normal gösterim -->
          <div class="space-y-2">
            <?php foreach ($products as $product): ?>
              <div class="menu-item flex items-start justify-between p-4 rounded-xl border border-amber-100">
                <div class="flex-1">
                  <h3 class="text-lg font-semibold text-gray-800 mb-1">
                    <?php echo htmlspecialchars($product['name']); ?>
                  </h3>
                  <?php if ($product['description']): ?>
                    <p class="text-sm text-gray-600 leading-relaxed">
                      <?php echo htmlspecialchars($product['description']); ?>
                    </p>
                  <?php endif; ?>
                </div>
                <?php if ($product['price'] > 0): ?>
                  <div class="ml-4 flex-shrink-0">
                    <span class="inline-flex items-center px-4 py-2 bg-gradient-to-r from-amber-500 to-orange-500 text-white font-bold rounded-full text-lg shadow-lg">
                      <?php echo number_format($product['price'], 0, ',', '.') . $currency; ?>
                    </span>
                  </div>
                <?php else: ?>
                  <div class="ml-4 flex-shrink-0">
                    <span class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-600 font-semibold rounded-full text-sm">
                      Çok Yakında
                    </span>
                  </div>
                <?php endif; ?>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <!-- Alt Kategori Geçiş Menüsü - Modern & Sticky -->
  <div class="fixed bottom-0 left-0 right-0 bg-white/95 backdrop-blur-md border-t-2 border-amber-100 shadow-2xl z-50 py-3 px-4">
    <div class="max-w-6xl mx-auto overflow-x-auto">
      <div class="flex gap-2 w-max mx-auto">
        <?php foreach ($all_categories as $cat): ?>
          <?php $is_active = $cat['id'] == $category['id']; ?>
          <a href="category.php?slug=<?php echo urlencode($cat['slug']); ?>" 
             class="px-5 py-2.5 rounded-full font-medium text-sm whitespace-nowrap transition-all shadow-md hover:shadow-lg
                    <?php echo $is_active 
                      ? 'bg-gradient-to-r from-amber-500 to-orange-500 text-white scale-105' 
                      : 'bg-white text-gray-700 hover:bg-amber-50 border border-amber-200'; ?>">
            <?php echo htmlspecialchars($cat['name']); ?>
          </a>
        <?php endforeach; ?>
      </div>
    </div>
  </div>

</body>
</html>