<?php
if (!file_exists('includes/config.php')) {
    header('Location: setup.php');
    exit;
}
require_once 'includes/config.php';

// Kategori slug
$slug = $_GET['slug'] ?? '';
if ($slug == '') { header("Location: index.php"); exit; }

// Kategori bilgisi
$stmt = $pdo->prepare("SELECT * FROM categories WHERE slug = ? AND is_active = 1");
$stmt->execute([$slug]);
$category = $stmt->fetch();
if (!$category) { header("Location: index.php"); exit; }

// Alt kategoriler
$stmt = $pdo->prepare("SELECT * FROM subcategories WHERE category_id=? ORDER BY display_order ASC");
$stmt->execute([$category['id']]);
$subcategories = $stmt->fetchAll();

// Ürünleri çek
if ($subcategories) {
    $products_by_sub = [];
    foreach ($subcategories as $sub) {
        $stmt = $pdo->prepare("
            SELECT p.* FROM products p
            JOIN product_subcategories ps ON p.id = ps.product_id
            WHERE ps.subcategory_id = ? AND p.is_active = 1
            ORDER BY p.display_order ASC, p.name ASC
        ");
        $stmt->execute([$sub['id']]);
        $products_by_sub[$sub['id']] = $stmt->fetchAll();
    }
} else {
    $stmt = $pdo->prepare("SELECT * FROM products WHERE category_id=? AND is_active=1 ORDER BY display_order ASC, name ASC");
    $stmt->execute([$category['id']]);
    $products = $stmt->fetchAll();
}

$all_categories = $pdo->query("SELECT * FROM categories WHERE is_active=1 ORDER BY display_order ASC")->fetchAll();

// Ayarlar
function getSetting($key, $default=''){
    global $pdo;
    $q=$pdo->prepare("SELECT setting_value FROM settings WHERE setting_key=?");
    $q->execute([$key]);
    $v=$q->fetchColumn();
    return $v!==false?$v:$default;
}

$phone   = getSetting('phone',"0");
$maps    = getSetting('maps_url',"#");
$currency = getSetting('currency',"₺");
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= htmlspecialchars($category['name']) ?> | Menü</title>

<script src="https://cdn.tailwindcss.com"></script>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">

<style>
body{font-family:'Inter',sans-serif}
.cover-overlay{background:linear-gradient(to top,rgba(0,0,0,.65),rgba(0,0,0,.05))}
.product-card{transition:all .18s ease}
.product-card:hover{background:#f8f8f8;transform:translateX(4px)}
</style>
</head>

<body class="bg-neutral-100 text-neutral-900">

<!-- Üst Bar -->
<header class="sticky top-0 z-50 bg-white shadow-sm">
  <div class="flex items-center justify-between px-4 py-3 max-w-xl mx-auto">
    <a href="index.php" class="flex items-center gap-2">
      <span class="text-xl">←</span>
      <span class="font-semibold">Geri</span>
    </a>
    <div class="flex gap-3">
      <a href="<?= htmlspecialchars($maps) ?>" target="_blank" class="text-sm px-3 py-1.5 rounded-full bg-neutral-900 text-white">Konum</a>
      <a href="tel:<?= htmlspecialchars($phone) ?>" class="text-sm px-3 py-1.5 rounded-full border">Ara</a>
    </div>
  </div>
</header>


<!-- Kategori Kapak -->
<?php if ($category['image'] && file_exists($category['image'])): ?>
<div class="relative h-56 w-full overflow-hidden">
    <img src="<?= htmlspecialchars($category['image']) ?>" class="w-full h-full object-cover">
    <div class="absolute inset-0 cover-overlay"></div>

    <div class="absolute bottom-0 left-0 p-6 text-white">
        <h1 class="text-3xl font-extrabold mb-1"><?= htmlspecialchars($category['name']) ?></h1>
        <p class="text-white/80 text-sm">Ürünleri keşfedin</p>
    </div>
</div>
<?php else: ?>
<div class="px-4 py-6 max-w-xl mx-auto">
    <h1 class="text-3xl font-extrabold"><?= htmlspecialchars($category['name']) ?></h1>
</div>
<?php endif; ?>


<!-- Ürünler -->
<div class="max-w-xl mx-auto px-4 py-6 pb-32">

<?php if ($subcategories): ?>

    <?php foreach ($subcategories as $sub): ?>
        <?php if (!empty($products_by_sub[$sub['id']])): ?>

        <h2 class="text-xl font-bold mb-3 mt-6"><?= htmlspecialchars($sub['name']) ?></h2>

        <div class="space-y-3">
        <?php foreach ($products_by_sub[$sub['id']] as $p): ?>
            <div class="product-card bg-white p-4 rounded-2xl shadow-sm flex justify-between items-start">

                <div class="flex-1">
                    <h3 class="font-semibold text-lg"><?= htmlspecialchars($p['name']) ?></h3>

                    <?php if ($p['description']): ?>
                    <p class="text-sm text-neutral-600 mt-1">
                        <?= htmlspecialchars($p['description']) ?>
                    </p>
                    <?php endif; ?>
                </div>

                <?php if ($p['price'] > 0): ?>
                <div class="ml-4">
                    <span class="bg-neutral-900 text-white px-4 py-2 rounded-full font-bold text-sm">
                        <?= number_format($p['price'],0,",",".") . $currency ?>
                    </span>
                </div>
                <?php endif; ?>

            </div>
        <?php endforeach; ?>
        </div>

        <?php endif; ?>
    <?php endforeach; ?>

<?php else: ?>

    <div class="space-y-3">
        <?php foreach ($products as $p): ?>
        <div class="product-card bg-white p-4 rounded-2xl shadow-sm flex justify-between items-start">

            <div class="flex-1">
                <h3 class="font-semibold text-lg"><?= htmlspecialchars($p['name']) ?></h3>
                <?php if ($p['description']): ?>
                <p class="text-sm text-neutral-600 mt-1"><?= htmlspecialchars($p['description']) ?></p>
                <?php endif; ?>
            </div>

            <div class="ml-4">
                <?php if ($p['price'] > 0): ?>
                <span class="bg-neutral-900 text-white px-4 py-2 rounded-full font-bold text-sm">
                    <?= number_format($p['price'],0,",",".") . $currency ?>
                </span>
                <?php else: ?>
                <span class="bg-neutral-200 text-neutral-700 px-4 py-2 rounded-full font-semibold text-xs">
                    Yakında
                </span>
                <?php endif; ?>
            </div>

        </div>
        <?php endforeach; ?>
    </div>

<?php endif; ?>

</div>


<!-- Alt kategori / kategori geçiş barı -->
<footer class="fixed bottom-0 left-0 right-0 bg-white border-t shadow-lg z-50">
  <div class="max-w-xl mx-auto overflow-x-auto">
    <div class="flex gap-2 p-3 w-max">

      <?php foreach ($all_categories as $c): ?>
      <a href="category.php?slug=<?= urlencode($c['slug']) ?>"
         class="px-4 py-2 rounded-full text-sm font-medium whitespace-nowrap
         <?= $c['id']==$category['id']
             ? 'bg-neutral-900 text-white'
             : 'bg-neutral-200 text-neutral-700' ?>">
        <?= htmlspecialchars($c['name']) ?>
      </a>
      <?php endforeach; ?>

    </div>
  </div>
</footer>

</body>
</html>
