# 🍽️ Karayel Menü Yönetim Sistemi

Modern, kullanıcı dostu restoran/kafe menü yönetim paneli. Mevcut HTML menülerinizi veritabanına aktarıp kolay yönetilebilir hale getirir.

## ✨ Özellikler

### 🔐 Güvenlik
- ✅ SQL Injection koruması (PDO Prepared Statements)
- ✅ XSS koruması
- ✅ CSRF token sistemi
- ✅ Güvenli şifre hash (password_hash/password_verify)
- ✅ Session yönetimi

### 📊 Admin Panel
- 📝 Kategori yönetimi (ekleme, düzenleme, silme, sıralama)
- 🍕 Ürün yönetimi (ekleme, düzenleme, silme, fiyat güncelleme)
- 🖼️ Görsel yönetimi
- 📊 Dashboard ile istatistikler
- ⚙️ Genel ayarlar yönetimi
- 📱 Responsive tasarım

### 🎨 Ön Yüz (Müşteri Menüsü)
- 📱 Mobil uyumlu
- ⚡ Hızlı yükleme
- 🎨 Modern Tailwind CSS tasarım
- 📱 QR kod menü desteği

## 📋 Gereksinimler

- PHP 7.4 veya üzeri
- MySQL 5.7 veya üzeri / MariaDB 10.2 veya üzeri
- Apache/Nginx web sunucu
- mod_rewrite etkin (opsiyonel, SEO URL'ler için)

## 🚀 Kurulum

### 1. Dosyaları Yükleyin
Tüm dosyaları web sunucunuzun root dizinine yükleyin (public_html, www, vb.)

### 2. Veritabanı Oluşturun
Hosting kontrol panelinizden (cPanel, Plesk vb.) veya phpMyAdmin'den yeni bir MySQL veritabanı oluşturun.

### 3. Kurulum Sihirbazını Çalıştırın
Tarayıcınızda `http://yourdomain.com/setup.php` adresine gidin ve adımları takip edin:

**Adım 1: Veritabanı Bilgileri**
- Veritabanı Host: `localhost` (çoğu hosting için)
- Veritabanı Adı: Oluşturduğunuz veritabanının adı
- Kullanıcı Adı: Veritabanı kullanıcı adı
- Şifre: Veritabanı şifresi

**Adım 2: Admin Kullanıcı**
- Kullanıcı adı, e-posta ve şifre belirleyin
- Bu bilgilerle admin paneline giriş yapacaksınız

**Adım 3-6: Otomatik Kurulum**
- Sistem otomatik olarak tabloları oluşturur
- Mevcut HTML menünüzdeki tüm verileri içe aktarır
- 200+ ürün otomatik olarak eklenir

**Adım 7: Tamamlandı**
- Kurulum tamamlandı! Admin paneline giriş yapabilirsiniz

### 4. Güvenlik
**ÇOK ÖNEMLİ:** Kurulum tamamlandıktan sonra `setup.php` dosyasını sunucudan silin!

```bash
rm setup.php
```

## 🎯 Kullanım

### Admin Paneline Giriş
`http://yourdomain.com/admin/` adresine gidin ve kurulumda belirlediğiniz kullanıcı adı/şifre ile giriş yapın.

### Kategori Yönetimi
1. Admin Panel → Kategoriler
2. Yeni kategori ekle veya mevcut kategorileri düzenle
3. Kategori görseli yükle
4. Sıralama düzenle (drag & drop)

### Ürün Yönetimi
1. Admin Panel → Ürünler
2. Yeni ürün ekle veya mevcut ürünleri düzenle
3. Fiyat güncelle
4. Açıklama ekle
5. Aktif/Pasif durumu değiştir

### Toplu Fiyat Güncelleme
1. Admin Panel → Ürünler
2. "Toplu İşlemler" butonuna tıklayın
3. Fiyatları yüzde veya sabit miktar olarak artır/azalt

### Ayarlar
1. Admin Panel → Ayarlar
2. Restoran adı, telefon, adres gibi genel bilgileri düzenle
3. Para birimi sembolünü değiştir
4. Fiyat güncelleme tarihini belirle

## 📁 Dosya Yapısı

```
karayel-menu-system/
├── admin/                      # Admin panel
│   ├── includes/              # Header, footer, vb.
│   ├── index.php              # Dashboard
│   ├── login.php              # Giriş sayfası
│   ├── logout.php             # Çıkış
│   ├── categories.php         # Kategori yönetimi
│   ├── products.php           # Ürün yönetimi
│   ├── settings.php           # Ayarlar
│   └── functions.php          # Yardımcı fonksiyonlar
├── includes/
│   └── config.php             # Veritabanı ayarları (otomatik oluşturulur)
├── assets/                    # CSS, JS, resimler
├── uploads/                   # Yüklenen görseller
├── resimler/                  # Mevcut menü görselleri
├── index.php                  # Ana sayfa (menü listesi)
├── kategori.php               # Kategori detay sayfası
└── setup.php                  # Kurulum sihirbazı (kurulum sonrası silinmeli!)
```

## 🔧 Veritabanı Yapısı

### Tablolar
- `categories` - Menü kategorileri
- `products` - Ürünler
- `subcategories` - Alt kategoriler (Ana Yemek → Kırmızı Et gibi)
- `product_subcategories` - Ürün-Alt kategori ilişkisi
- `admin_users` - Admin kullanıcılar
- `settings` - Sistem ayarları

## 🎨 Tasarım Özelleştirme

Sistem Tailwind CSS kullanır. Renkleri değiştirmek için:

### Ana Renk Paleti
- Birincil: `amber-600` (turuncu/altın)
- İkincil: `orange-600`
- Başarı: `green-500`
- Hata: `red-500`

CSS dosyalarını düzenleyerek özelleştirebilirsiniz.

## 🛡️ Güvenlik İpuçları

1. ✅ `setup.php` dosyasını kurulum sonrası mutlaka silin
2. ✅ Güçlü admin şifresi kullanın
3. ✅ `/admin` klasörüne .htaccess ile IP kısıtlaması ekleyin (opsiyonel)
4. ✅ PHP versiyonunuzu güncel tutun
5. ✅ Düzenli yedekleme yapın

### .htaccess İle IP Kısıtlama Örneği
```apache
# /admin/.htaccess
Order Deny,Allow
Deny from all
Allow from 123.456.789.0  # Kendi IP'niz
```

## 🔄 Güncelleme

Yeni ürün eklerken:
1. Admin Panel → Ürünler → Yeni Ürün Ekle
2. Form doldurun
3. Kaydet

Fiyat değiştirirken:
1. Admin Panel → Ürünler → İlgili ürünün "Düzenle" butonuna tıklayın
2. Fiyatı güncelleyin
3. Kaydet

## 📱 Mobil Optimizasyon

Sistem tamamen responsive tasarlandı:
- 📱 Telefonlar için optimize menü gösterimi
- 🖥️ Tabletler için uyarlanmış layout
- 💻 Masaüstü için tam özellikli panel

## 🆘 Sorun Giderme

### "Cannot connect to database" Hatası
- Veritabanı bilgilerini kontrol edin
- MySQL servisinin çalıştığını doğrulayın

### "Permission Denied" Hatası
- `/uploads` ve `/includes` klasörlerine yazma izni verin
```bash
chmod 755 uploads/
chmod 644 includes/config.php
```

### Resimler Görünmüyor
- `resimler/` klasöründeki dosyaların varlığını kontrol edin
- Dosya izinlerini kontrol edin

## 🙋 Destek

Sorularınız için:
- Hosting sağlayıcınızın desteğine başvurun
- PHP/MySQL dokümantasyonunu inceleyin

## 📄 Lisans

Bu proje özel olarak Karayel Cafe & Binicilik için geliştirilmiştir.

## 🎉 Özellikler v1.0

- ✅ Otomatik kurulum sistemi
- ✅ 17 kategori otomatik import
- ✅ 200+ ürün otomatik import
- ✅ Alt kategori desteği (Ana Yemek)
- ✅ CRUD işlemleri (Create, Read, Update, Delete)
- ✅ Görsel yükleme sistemi
- ✅ Fiyat formatlama
- ✅ Türkçe karakter desteği
- ✅ Responsive tasarım
- ✅ Güvenli authentication
- ✅ Dashboard istatistikleri

## 🔮 Gelecek Özellikler

- [ ] QR kod generator
- [ ] PDF menü export
- [ ] Çoklu dil desteği
- [ ] Ürün varyantları (küçük/büyük boy)
- [ ] Stok takibi
- [ ] Sipariş sistemi entegrasyonu
- [ ] Analitik raporlar

---

**Geliştirici Notu:** Sistem kullanıma hazırdır. Kurulum sihirbazı tüm verileri otomatik olarak içe aktarır.

🚀 **Başarılar! İyi kullanımlar.**
