<?php
session_start();
require_once '../includes/config.php';
require_once 'functions.php';

requireLogin();

// Ayarları kaydet
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (verifyCSRFToken($_POST['csrf_token'] ?? '')) {
        $settings = [
            'restaurant_name' => trim($_POST['restaurant_name']),
            'phone' => trim($_POST['phone']),
            'address' => trim($_POST['address']),
            'maps_url' => trim($_POST['maps_url']),
            'price_update_date' => trim($_POST['price_update_date']),
            'currency' => trim($_POST['currency'])
        ];
        
        try {
            foreach ($settings as $key => $value) {
                setSetting($key, $value);
            }
            
            setSuccessMessage('Ayarlar başarıyla güncellendi!');
            header('Location: settings.php');
            exit;
        } catch (Exception $e) {
            setErrorMessage('Ayarlar kaydedilirken hata oluştu: ' . $e->getMessage());
        }
    } else {
        setErrorMessage('Güvenlik hatası! Lütfen tekrar deneyin.');
    }
}

// Mevcut ayarları çek
$current_settings = [
    'restaurant_name' => getSetting('restaurant_name', 'Karayel Cafe & Binicilik'),
    'phone' => getSetting('phone', '05078531610'),
    'address' => getSetting('address', 'Bursa, Türkiye'),
    'maps_url' => getSetting('maps_url', 'https://maps.app.goo.gl/XbFYeuwkYQBQJwxu7'),
    'price_update_date' => getSetting('price_update_date', date('d F Y')),
    'currency' => getSetting('currency', '₺')
];

$page_title = 'Ayarlar';
$page_description = 'Genel sistem ayarlarını yönetin';
include 'includes/header.php';
?>

<div class="max-w-4xl mx-auto space-y-6">
    <!-- Genel Ayarlar -->
    <div class="bg-white rounded-xl shadow-md p-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Genel Ayarlar</h2>
        
        <form method="POST" action="settings.php" class="space-y-6">
            <input type="hidden" name="csrf_token" value="<?php echo generateCSRFToken(); ?>">
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Restoran Adı</label>
                <input type="text" name="restaurant_name" required 
                       value="<?php echo h($current_settings['restaurant_name']); ?>"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500 focus:border-transparent">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Telefon</label>
                <input type="text" name="phone" required 
                       value="<?php echo h($current_settings['phone']); ?>"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500 focus:border-transparent">
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Adres</label>
                <textarea name="address" rows="3" required
                          class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500 focus:border-transparent"><?php echo h($current_settings['address']); ?></textarea>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Google Maps URL</label>
                <input type="url" name="maps_url" required 
                       value="<?php echo h($current_settings['maps_url']); ?>"
                       class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500 focus:border-transparent">
                <p class="mt-1 text-sm text-gray-500">Konum butonu için kullanılacak</p>
            </div>

            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Para Birimi Sembolü</label>
                    <input type="text" name="currency" required 
                           value="<?php echo h($current_settings['currency']); ?>"
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500 focus:border-transparent">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Fiyat Güncelleme Tarihi</label>
                    <input type="text" name="price_update_date" required 
                           value="<?php echo h($current_settings['price_update_date']); ?>"
                           placeholder="15 Mayıs 2025"
                           class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-amber-500 focus:border-transparent">
                </div>
            </div>

            <div class="flex gap-4">
                <button type="submit" 
                        class="bg-amber-600 hover:bg-amber-700 text-white font-bold py-3 px-8 rounded-lg transition">
                    Kaydet
                </button>
            </div>
        </form>
    </div>

    <!-- Sistem Bilgileri -->
    <div class="bg-white rounded-xl shadow-md p-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Sistem Bilgileri</h2>
        
        <div class="space-y-4">
            <div class="flex justify-between py-3 border-b border-gray-200">
                <span class="text-gray-600">PHP Versiyonu</span>
                <span class="font-semibold"><?php echo phpversion(); ?></span>
            </div>
            <div class="flex justify-between py-3 border-b border-gray-200">
                <span class="text-gray-600">Veritabanı</span>
                <span class="font-semibold">MySQL <?php echo $pdo->query('SELECT VERSION()')->fetchColumn(); ?></span>
            </div>
            <div class="flex justify-between py-3 border-b border-gray-200">
                <span class="text-gray-600">Veritabanı Adı</span>
                <span class="font-semibold"><?php echo DB_NAME; ?></span>
            </div>
            <div class="flex justify-between py-3 border-b border-gray-200">
                <span class="text-gray-600">Maksimum Dosya Yükleme</span>
                <span class="font-semibold"><?php echo ini_get('upload_max_filesize'); ?></span>
            </div>
            <div class="flex justify-between py-3">
                <span class="text-gray-600">Sistem Sürümü</span>
                <span class="font-semibold">v1.0</span>
            </div>
        </div>
    </div>

    <!-- Hızlı Linkler -->
    <div class="bg-white rounded-xl shadow-md p-8">
        <h2 class="text-2xl font-bold text-gray-800 mb-6">Hızlı Erişim</h2>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <a href="../index.php" target="_blank" 
               class="flex items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition">
                <svg class="w-8 h-8 text-amber-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                </svg>
                <div>
                    <p class="font-semibold text-gray-800">Menüyü Görüntüle</p>
                    <p class="text-sm text-gray-500">Müşteri menüsünü yeni sekmede aç</p>
                </div>
            </a>

            <a href="index.php" 
               class="flex items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition">
                <svg class="w-8 h-8 text-blue-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                </svg>
                <div>
                    <p class="font-semibold text-gray-800">Dashboard</p>
                    <p class="text-sm text-gray-500">Ana sayfa ve istatistikler</p>
                </div>
            </a>

            <a href="categories.php" 
               class="flex items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition">
                <svg class="w-8 h-8 text-green-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                </svg>
                <div>
                    <p class="font-semibold text-gray-800">Kategoriler</p>
                    <p class="text-sm text-gray-500">Kategori yönetimi</p>
                </div>
            </a>

            <a href="products.php" 
               class="flex items-center p-4 border border-gray-200 rounded-lg hover:bg-gray-50 transition">
                <svg class="w-8 h-8 text-purple-600 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                </svg>
                <div>
                    <p class="font-semibold text-gray-800">Ürünler</p>
                    <p class="text-sm text-gray-500">Ürün yönetimi</p>
                </div>
            </a>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
