<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'includes/config.php';

// getSetting FONKSİYONU (500 fix)
function getSetting($k,$d=''){
  global $pdo;
  $s=$pdo->prepare("SELECT setting_value FROM settings WHERE setting_key=?");
  $s->execute([$k]);
  return $s->fetchColumn() ?: $d;
}

$slug = $_GET['slug'] ?? '';
if(!$slug){ header("Location:index.php"); exit; }

// Kategori
$stmt = $pdo->prepare("SELECT * FROM categories WHERE slug=? AND is_active=1");
$stmt->execute([$slug]);
$category = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$category){ header("Location:index.php"); exit; }

// Üst slider için TÜM kategoriler
$allCats = $pdo->query("
    SELECT * FROM categories 
    WHERE is_active=1 
    ORDER BY display_order ASC
")->fetchAll(PDO::FETCH_ASSOC);

// Ürünler
$stmt = $pdo->prepare("
    SELECT * FROM products 
    WHERE category_id=? AND is_active=1
    ORDER BY display_order ASC, name ASC
");
$stmt->execute([$category['id']]);
$products = $stmt->fetchAll(PDO::FETCH_ASSOC);

$currency = getSetting('currency','₺');
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= htmlspecialchars($category['name']) ?></title>

<script src="https://cdn.tailwindcss.com"></script>
<style>
body{font-family:system-ui,-apple-system}
.active{outline:3px solid #ffbf47}
</style>
</head>

<body class="bg-[#f6f2e9]">

<!-- HEADER -->
<header class="bg-[#2f3640] text-white px-4 py-4 flex items-center gap-3">
  <a href="index.php" class="text-xl">←</a>
  <h1 class="font-semibold text-lg"><?= htmlspecialchars($category['name']) ?></h1>
</header>

<!-- YATAY KAYDIRMALI KATEGORİ SLIDER -->
<div class="px-3 pt-4 overflow-x-auto">
  <div class="flex gap-3 w-max">
    <?php foreach($allCats as $c): ?>
    <a href="category.php?slug=<?= urlencode($c['slug']) ?>"
       class="shrink-0 w-28 h-20 rounded-xl overflow-hidden relative shadow 
       <?= $c['id']==$category['id'] ? 'active' : '' ?>">

      <?php if(!empty($c['image'])): ?>
      <img src="<?= htmlspecialchars($c['image']) ?>" class="w-full h-full object-cover">
      <?php endif; ?>

      <div class="absolute inset-0 bg-black/40 flex items-center justify-center">
        <span class="text-white text-xs font-medium text-center px-1">
          <?= htmlspecialchars($c['name']) ?>
        </span>
      </div>

    </a>
    <?php endforeach; ?>
  </div>
</div>

<!-- ÜRÜN LİSTESİ -->
<div class="max-w-xl mx-auto px-4 py-5 space-y-3">

<?php foreach($products as $p): ?>
<div class="bg-white rounded-xl p-3 shadow flex gap-3">

  

  <div class="flex-1">
    <div class="flex justify-between">
      <h3 class="font-semibold text-sm"><?= htmlspecialchars($p['name']) ?></h3>
      <?php if($p['price']>0): ?>
      <span class="font-bold text-sm">
        <?= number_format($p['price'],0,",",".").$currency ?>
      </span>
      <?php endif; ?>
    </div>

    <?php if(!empty($p['description'])): ?>
    <p class="text-xs text-neutral-500 mt-1">
      <?= htmlspecialchars($p['description']) ?>
    </p>
    <?php endif; ?>
  </div>

</div>
<?php endforeach; ?>

</div>

</body>
</html>
