<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'includes/config.php';

// Kategoriler
$cats = $pdo->query("
    SELECT * FROM categories 
    WHERE is_active=1 
    ORDER BY display_order ASC, name ASC
")->fetchAll(PDO::FETCH_ASSOC);

// Ayarlar
function getSetting($k,$d=''){
  global $pdo;
  $s=$pdo->prepare("SELECT setting_value FROM settings WHERE setting_key=?");
  $s->execute([$k]);
  return $s->fetchColumn() ?: $d;
}

$restaurant = getSetting('restaurant_name','QR Menü');
$phone      = getSetting('phone','0500000000');
$maps_url   = getSetting('maps_url','#');
?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?= htmlspecialchars($restaurant) ?></title>

<script src="https://cdn.tailwindcss.com"></script>
<style>
body{font-family:system-ui,-apple-system}
</style>
</head>

<body class="bg-[#f6f2e9]">

<!-- HEADER -->
<header class="bg-[#2f3640] text-white px-4 py-4">
  <div class="max-w-xl mx-auto flex items-center justify-between">

    <!-- SOL: BAŞLIK -->
    <h1 class="text-lg font-semibold">
      <?= htmlspecialchars($restaurant) ?>
    </h1>

    <!-- SAĞ: KONUM & ARA -->
    <div class="flex gap-2 text-sm">
      <a href="<?= htmlspecialchars($maps_url) ?>" target="_blank"
         class="px-3 py-1.5 rounded-lg bg-white/10 hover:bg-white/20 transition">
        📍 Konum
      </a>
      <a href="tel:<?= htmlspecialchars($phone) ?>"
         class="px-3 py-1.5 rounded-lg bg-white/10 hover:bg-white/20 transition">
        📞 Ara
      </a>
    </div>

  </div>
</header>

<!-- KATEGORİLER -->
<main class="max-w-xl mx-auto px-4 py-4 space-y-4">

<?php foreach($cats as $c): ?>
<div class="bg-white rounded-xl shadow overflow-hidden">

  <?php if(!empty($c['image'])): ?>
  <a href="category.php?slug=<?= urlencode($c['slug']) ?>">
    <div class="h-36">
      <img src="<?= htmlspecialchars($c['image']) ?>" class="w-full h-full object-cover">
    </div>
  </a>
  <?php endif; ?>

  <div class="p-4">
    <a href="category.php?slug=<?= urlencode($c['slug']) ?>">
      <h2 class="font-semibold text-lg"><?= htmlspecialchars($c['name']) ?></h2>
    </a>
  </div>

</div>
<?php endforeach; ?>

</main>

</body>
</html>
