<?php
// HATA GÖRMEK İSTEMEZSEN BU İKİ SATIRI SİLEBİLİRSİN
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!file_exists(__DIR__ . '/includes/config.php')) {
    die('includes/config.php bulunamadı');
}
require_once __DIR__ . '/includes/config.php';

// ========== AYAR FONKSİYONU ==========
if (!function_exists('getSetting')) {
    function getSetting($key, $default = '') {
        global $pdo;
        $q = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
        $q->execute([$key]);
        $val = $q->fetchColumn();
        return $val !== false ? $val : $default;
    }
}

// ========== KATEGORİLER ==========
$stmt = $pdo->query("SELECT * FROM categories WHERE is_active = 1 ORDER BY display_order ASC, name ASC");
$allCategories = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Gösterim mantığı
$showAll = isset($_GET['all']) && $_GET['all'] == '1';
$maxPrimary = 6;
$displayCategories = $showAll ? $allCategories : array_slice($allCategories, 0, $maxPrimary);

// ========== AYARLAR ==========
$restaurant = getSetting('restaurant_name', 'QR Menü');
$phone      = getSetting('phone', '05000000000');
$mapsUrl    = getSetting('maps_url', '#');

// ========== DİNAMİK GÜN / SAAT MESAJI ==========
$days = [
    1 => 'Pazartesi',
    2 => 'Salı',
    3 => 'Çarşamba',
    4 => 'Perşembe',
    5 => 'Cuma',
    6 => 'Cumartesi',
    7 => 'Pazar'
];

$dayName = $days[(int)date('N')] ?? '';
$hour    = (int)date('H');

if ($hour < 11) {
    $timeMessage = 'Günaydın! Hafif başlangıçlar için menümüz hazır.';
} elseif ($hour < 17) {
    $timeMessage = 'Öğle arası için ideal lezzetler sizi bekliyor.';
} elseif ($hour < 23) {
    $timeMessage = 'Akşam menümüz serviste. Keyifli bir akşam dileriz.';
} else {
    $timeMessage = 'Gece atıştırmalıkları için menümüzden seçim yapabilirsiniz.';
}

?>
<!doctype html>
<html lang="tr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<title><?= htmlspecialchars($restaurant) ?> | Dijital Menü</title>

<script src="https://cdn.tailwindcss.com"></script>
<style>
body{font-family:system-ui,-apple-system,BlinkMacSystemFont,"Segoe UI",sans-serif}
body{background:#1f2933 !important;}
</style>

</style>
</head>

<!-- HEADER -->
<header class="bg-white/90 backdrop-blur border-b border-neutral-200">
  <div class="max-w-xl mx-auto px-4 py-4 flex items-center justify-between">
    <div>
      <h1 class="text-lg font-bold tracking-tight"><?= htmlspecialchars($restaurant) ?></h1>
      <div class="inline-flex items-center gap-2 mt-2 px-3 py-1.5 rounded-lg
            bg-[#f3e8da] border border-[#d6c6b2] shadow-sm">
    
    <span class="text-[11px] font-medium text-[#6b4f2c]">
        <?= htmlspecialchars($dayName) ?>
    </span>

    <span class="w-px h-3 bg-[#c8b29a]"></span>

    <span class="text-[11px] text-[#6b4f2c]">
        <?= htmlspecialchars($timeMessage) ?>
    </span>
</div>

    </div>

    <div class="flex gap-2 text-xs">
      <a href="<?= htmlspecialchars($mapsUrl) ?>" target="_blank"
         class="px-3 py-1.5 rounded-full bg-neutral-100 hover:bg-neutral-200 border border-neutral-200 transition">
        📍 Konum
      </a>
      <a href="tel:<?= htmlspecialchars($phone) ?>"
         class="px-3 py-1.5 rounded-full bg-neutral-900 text-white hover:bg-neutral-800 transition">
        📞 Ara
      </a>
    </div>
  </div>
</header>

<!-- KATEGORİLER -->
<main class="max-w-xl mx-auto px-4 py-5 space-y-4 pb-12">

  <?php if (empty($displayCategories)): ?>
    <div class="p-4 bg-yellow-100 border border-yellow-300 rounded-xl text-sm">
      Henüz aktif kategori bulunmuyor.
    </div>
  <?php endif; ?>

  <?php foreach ($displayCategories as $cat): ?>
    <a href="category.php?slug=<?= urlencode($cat['slug']) ?>"
       class="block bg-white/90 rounded-2xl shadow-sm hover:shadow-md overflow-hidden transition">

      <?php if (!empty($cat['image'])): ?>
        <div class="relative aspect-video">

          <img src="<?= htmlspecialchars($cat['image']) ?>" class="w-full h-full object-cover" alt="<?= htmlspecialchars($cat['name']) ?>">
          <div class="absolute inset-0 bg-gradient-to-t from-black/60 via-black/10 to-transparent"></div>
          <div class="absolute inset-0 flex items-center justify-center">
    <div class="px-5 py-2.5 rounded-lg bg-black/45 backdrop-blur-sm">
        <h2 class="text-lg font-semibold text-white text-center tracking-wide">
            <?= htmlspecialchars($cat['name']) ?>
        </h2>
        <p class="text-[11px] text-white/80 text-center mt-0.5">
            Menüyü görüntüle
        </p>
    </div>
</div>

        </div>
      <?php else: ?>
        <div class="p-4">
          <h2 class="text-lg font-semibold"><?= htmlspecialchars($cat['name']) ?></h2>
          <p class="text-xs text-neutral-500 mt-1">Menüyü görüntüle</p>
        </div>
      <?php endif; ?>

    </a>
  <?php endforeach; ?>

  <?php if (count($allCategories) > $maxPrimary): ?>
    <div class="pt-2">
      <?php if (!$showAll): ?>
        <a href="?all=1"
           class="block text-center text-sm text-neutral-700 underline underline-offset-4">
          Tüm menüyü göster
        </a>
      <?php else: ?>
        <a href="index.php"
           class="block text-center text-sm text-neutral-700 underline underline-offset-4">
          Sadece ana kategorileri göster
        </a>
      <?php endif; ?>
    </div>
  <?php endif; ?>

</main>

</body>
</html>
